//								EJEMPLO 30
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//Los mdulos CCPx. Modo de Captura. Medida del tiempo entre un pulso y el siguiente.
//
//El ejemplo emplea el mdulo CCP1 y trata de capturar el valor del TMR1 cada vez que lleguen
//un flanco descendente y otro ascendente por la lnea RC2/CCP1. Conocida la velocidad a la 
//que evoluciona el TMR1, se puede determinar el lapsus de tiempo transcurrido entre ambos
//flancos, lo que nos dar el tiempo transcurrido entre el final de un pulso y el comienzo 
//del siguiente.
//
//La pantalla LCD visualiza dicho lapsus de tiempo expresado en microsegundos.
		
#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use fast_io (C)
#use delay(clock=4000000)

#include <lcd2.c>		//Incluir funciones de manejo del LCD

int captura=1;			//Contiene n de captura realizada
int32 v_captura;		//Contiene valor capturado

#int_ccp1		//Vector de interrupcin del CCP1
tratamiento()	//Funcin de tratamiento del CCP1
{ 
	if (captura < 2)	//Se han producido 2 capturas ??
	 {					//No, se ha detectado el flanco descendente	
		captura ++;		//Siguiente captura
		CCP_1=0;	
		setup_ccp1(ccp_capture_re);	//siguiente captura en el flanco ascendente
		set_timer1(0);	//Repone el TMR1 con 0
	}
	else 
	{
		captura = 1;			//Restablecer 1 captura
		lcd_enviar(LCD_COMANDO,LCD_HOME);	//Coloca el cursor
		v_captura=CCP_1;		//Lee valor capturado
		v_captura=v_captura*8;	//Ajusta *8 segn valor del preescaler
		printf(lcd_putc,"%06lu",v_captura);	//Visualiza resultado
		setup_ccp1(ccp_capture_fe);	//Siguiente captura en el flanco descendente
	}
}
	
main()
{  
	SETUP_ADC_PORTS(NO_ANALOGS);//Puerta A Digital
	set_tris_c(0xff);			//Puerta C entrada
	enable_interrupts(int_ccp1); //Activa interrupcin del CCP1
	lcd_init();					//Inicia el mdulo LCD

//El TMR1 acta en el modo temporizador con reloj interno y un preescaler 1:8 evoluciona cada 8uS a 4MHz.
//Segn esto, el periodo mximo que se puede medir estar comprendido entre 0,5s (2Hz) y 8 uS (125 KHz) aproximadamente.
//Para otros rangos se debe seleccionar un preescaler diferente.

	setup_timer_1(T1_INTERNAL | T1_DIV_BY_8);	//TMR1 Interno y preescaler de 1:8
	
//El mdulo CCP1 acta en modo de captura cada flanco ascendente

	setup_ccp1(ccp_capture_fe);	//1 Captura en el flanco descendente
	enable_interrupts(global);	//Habilita interrupciones

	while(1)
	{	
	}
}	
